/**
 * 
 */
package simulator.plus;

import service.ComposedState;
import service.SimpleState;
import service.State;

/**
 * @author Rarefatto
 *
 */
public class SimilarState extends State implements Comparable<SimilarState>{
	private SimpleState targetState;
	private ComposedState avalaibleState;
	public SimilarState(SimpleState targetState,ComposedState availableState){
		super("");
		this.targetState=targetState;
		this.avalaibleState=availableState;
		setName(targetState.getName()+", "+availableState.getName());
	}
	public SimpleState getTargetState(){
		return targetState;
	}
	public ComposedState getAvalableServiceState(){
		return avalaibleState;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((avalaibleState == null) ? 0 : avalaibleState.hashCode());
		result = prime * result
				+ ((targetState == null) ? 0 : targetState.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SimilarState other = (SimilarState) obj;
		if (avalaibleState == null) {
			if (other.avalaibleState != null)
				return false;
		} else if (!avalaibleState.equals(other.avalaibleState))
			return false;
		if (targetState == null) {
			if (other.targetState != null)
				return false;
		} else if (!targetState.equals(other.targetState))
			return false;
		return true;
	}
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(SimilarState o) {
		int condition1=targetState.getName().compareTo(o.targetState.getName());
		if(condition1!=0)
			return condition1;
		int condition2=avalaibleState.getName().compareTo(o.avalaibleState.getName());
		if(condition2!=0)
			return condition2;
		return 0;
	}
	
	public String[] toStringArray(){
		return new String[]{targetState.getName(),avalaibleState.getName()};
	}
	/* (non-Javadoc)
	 * @see service.State#isFinal()
	 */
	@Override
	public boolean isFinal() {
		if(avalaibleState.isFinal())
			return true;
		else return false;
	}
	/* (non-Javadoc)
	 * @see service.State#isInitial()
	 */
	@Override
	public boolean isInitial() {
		if(targetState.isInitial() && avalaibleState.isInitial())
			return true;
		else return false;
	}

}
